<?php
/**
 * Uninstall OOPVulns.
 *
 * @package OOPVulns
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

/**
 * Remove plugin data for the current site.
 */
function oopvulns_uninstall_site_data() {
	delete_option( 'oopvulns_settings' );
	delete_option( 'oopvulns_core_result' );
	delete_option( 'oopvulns_plugins_result' );
	delete_option( 'oopvulns_themes_result' );
	delete_option( 'oopvulns_last_scan' );
	delete_option( 'oopvulns_last_notification' );
	delete_transient( 'oopvulns_messages' );

	wp_clear_scheduled_hook( 'oopvulns_scan' );
	wp_clear_scheduled_hook( 'oopvulns_notify' );

	global $wpdb;

	$wpdb->query(
		$wpdb->prepare(
			"DELETE FROM {$wpdb->options} WHERE option_name LIKE %s OR option_name LIKE %s",
			'_transient_oopvulns_%',
			'_transient_timeout_oopvulns_%'
		)
	);
}

if ( is_multisite() ) {
	$site_ids = get_sites(
		array(
			'fields' => 'ids',
		)
	);

	foreach ( $site_ids as $site_id ) {
		switch_to_blog( (int) $site_id );
		oopvulns_uninstall_site_data();
		restore_current_blog();
	}
} else {
	oopvulns_uninstall_site_data();
}
