<?php
/**
 * Plugin Name:  OOPVulns - Vulnerability Scanner
 * Plugin URI: https://oopvulns.com/
 * Description: Monitor your WordPress site for security vulnerabilities in core, plugins, and themes.
 * Version: 1.0.0
 * Requires at least: 5.8
 * Requires PHP: 7.4
 * Author:  OOPVulns 
 * Author URI: https://www.oopspam.com/
 * License: GPL-3.0-or-later
 * License URI: https://www.gnu.org/licenses/gpl-3.0.txt
 * Text Domain: oopvulns-vulnerability-scanner
 * Domain Path: /languages
 *
 * @package OOPVulns
 */

namespace OOPVulns;

defined( 'ABSPATH' ) || exit;

// Define plugin constants.
define( 'OOPVULNS_VERSION', '1.0.0' );
define( 'OOPVULNS_FILE', __FILE__ );
define( 'OOPVULNS_PATH', plugin_dir_path( __FILE__ ) );
define( 'OOPVULNS_URL', plugin_dir_url( __FILE__ ) );
define( 'OOPVULNS_BASENAME', plugin_basename( __FILE__ ) );
define( 'OOPVULNS_API_BASE', 'https://api.oopspam.com/v1/wp/' );

// Autoloader for plugin classes.
spl_autoload_register( function ( $class ) {
	$prefix = 'OOPVulns\\';
	$len    = strlen( $prefix );

	if ( strncmp( $prefix, $class, $len ) !== 0 ) {
		return;
	}

	$relative_class = substr( $class, $len );
	$file           = OOPVULNS_PATH . 'includes/class-' . strtolower( str_replace( '_', '-', $relative_class ) ) . '.php';

	if ( file_exists( $file ) ) {
		require $file;
	}
} );

// Initialize the plugin.
add_action( 'init', function () {
	$plugin = Plugin::get_instance();
	$plugin->init();
} );

// Activation hook.
register_activation_hook( __FILE__, function () {
	require_once OOPVULNS_PATH . 'includes/class-plugin.php';
	Plugin::activate();
} );

// Deactivation hook.
register_deactivation_hook( __FILE__, function () {
	require_once OOPVULNS_PATH . 'includes/class-plugin.php';
	Plugin::deactivate();
} );
